rm(list=ls())
library(Rlab)
library(matlib)

k=0.3
  H=8.79
tau=0.3
lam1=1
lam2=1



theta<-iTau(gumbelCopula(dim=2),tau=tau)
cop<-mvdc(gumbelCopula(param=theta,dim=2)
          ,margins = c("exp","exp"),
          paramMargins =
            list(list(1/lam1),list(1/lam2)))
dat=rMvdc(1000000,cop)
sigma=matrix(NA,ncol=2,nrow=2)
sigma[1,1]=var(dat[,1])
sigma[2,2]=var(dat[,2])
sigma[1,2]=cov(dat[,1],dat[,2])
sigma[2,1]=sigma[1,2]
sigma
mu0<-c(lam1,lam2)


delta1=1.25
delta2=1.25
lam11=lam1*delta1
lam21=lam2*delta2
# define copula by shifts
cop<-mvdc(gumbelCopula(param=theta,dim=2)
          ,margins = c("exp","exp"),
          paramMargins =
            list(list(1/lam11),list(1/lam21)))


ATS<-c(0)
for(i in 1:1000)
{
  Ct<-c(0)
  St<-c(0,0)
  TS<-0
  Qt<-c(0)
  while(Qt<H)
  {
    
    Xt<-t(rMvdc(1,cop))
    #MCUSUM
    Ct<-sqrt(t(St+Xt-mu0)%*% inv(sigma)%*% (St+Xt-mu0))
    if(Ct<=k) St<-c(0,0)
    if(Ct>k) St<-(St+Xt-mu0)%*%(1-k/(Ct))
    Qt<-sqrt(t(St)%*% inv(sigma)%*% St)
    St<-St
    TS<-TS+max(Xt)
  }
  ATS[i]<-TS
  print(i)
}
ATS_sim<-mean(ATS)
ATS_sim